(function () {
	'use strict';

	function getQueryParam(name) {
		var params = new URLSearchParams(window.location.search);
		var v = params.get(name);
		return v === null ? '' : v;
	}

	function setFieldValueByFieldId(formId, fieldId, value) {
		if (!value) return false;

		var el = document.getElementById('wpforms-' + formId + '-field_' + fieldId);
		if (!el) {
			el = document.querySelector('input[name="wpforms[fields][' + fieldId + ']"], textarea[name="wpforms[fields][' + fieldId + ']"], select[name="wpforms[fields][' + fieldId + ']"]');
		}
		if (!el) return false;

		// If el is container, pick inner input
		if (el.tagName && el.tagName.toLowerCase() !== 'input' && el.querySelector) {
			var inner = el.querySelector('input, textarea, select');
			if (inner) el = inner;
		}

		try {
			el.value = value;
			// Trigger events so WPForms picks up changes
			el.dispatchEvent(new Event('input', { bubbles: true }));
			el.dispatchEvent(new Event('change', { bubbles: true }));
			if (window.jQuery) {
				window.jQuery(el).trigger('input').trigger('change');
			}
			return true;
		} catch (e) {
			console && console.log && console.log('rccc-prefill set error', e);
			return false;
		}
	}

	document.addEventListener('DOMContentLoaded', function () {
		// Debug logs
		console.log('rccc-prefill: DOMContentLoaded');
		console.log('rccc-prefill: location.search=', window.location.search);
		console.log('rccc-prefill: rcccPrefillConfig=', typeof rcccPrefillConfig !== 'undefined' ? rcccPrefillConfig : null);

		if ( typeof rcccPrefillConfig === 'undefined' ) return;
		var cfg = rcccPrefillConfig;
		var formId = cfg.formId || 0;
		var map = cfg.mapping || {};

		// If no querystring, still try to run (useful for debugging)
		var qs = window.location.search || '';

		Object.keys(map).forEach(function (paramName) {
			var fieldId = map[paramName];
			var value = getQueryParam(paramName);
			console.log('rccc-prefill: param', paramName, 'fieldId', fieldId, 'value', value);
			if ( value ) {
				var ok = setFieldValueByFieldId(formId, String(fieldId), value);
				console.log('rccc-prefill: setField', fieldId, 'ok=', ok);
			}
		});
	});
})();