<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function rccc_home_register_cpts() {
	$common_args = array(
		'public'        => true,
		'show_ui'       => true,
		'show_in_rest'  => true,
		'rewrite'       => array( 'slug' => 'rccc' ),
		'supports'      => array( 'title', 'editor', 'author', 'custom-fields' ),
		'has_archive'   => false,
		'capability_type' => 'post',
		'map_meta_cap'  => true,
	);

	// Projects
	register_post_type(
		'rccc_project',
		array_merge(
			$common_args,
			array(
				'label'         => __( 'Projects', 'rccc-homeowner' ),
				'menu_position' => 20,
				'show_in_menu'  => true,
				'rewrite'       => array( 'slug' => 'projects' ),
			)
		)
	);

	// Estimates
	register_post_type(
		'rccc_estimate',
		array_merge(
			$common_args,
			array(
				'label'   => __( 'Estimates', 'rccc-homeowner' ),
				'rewrite' => array( 'slug' => 'estimates' ),
			)
		)
	);

	// Invoices
	register_post_type(
		'rccc_invoice',
		array_merge(
			$common_args,
			array(
				'label'   => __( 'Invoices', 'rccc-homeowner' ),
				'rewrite' => array( 'slug' => 'invoices' ),
			)
		)
	);

	// Complaints
	register_post_type(
		'rccc_complaint',
		array_merge(
			$common_args,
			array(
				'label'   => __( 'Complaints', 'rccc-homeowner' ),
				'rewrite' => array( 'slug' => 'complaints' ),
			)
		)
	);

	// Consultations
	register_post_type(
		'rccc_consultation',
		array_merge(
			$common_args,
			array(
				'label'   => __( 'Consultations', 'rccc-homeowner' ),
				'rewrite' => array( 'slug' => 'consultations' ),
			)
		)
	);
}
add_action( 'init', 'rccc_home_register_cpts' );