<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integrations: create rccc_project from WPForms submissions (Get Matched form).
 *
 * This file is configured for WPForms form ID 27 by default.
 *
 * IMPORTANT:
 * - Update $wpforms_map below so 'title' points to the WPForms field ID/key that should become the Project Title,
 *   and 'description' points to the field used for Project Description.
 *
 * Example: if your WPForms has a single-line "Project Title" field with ID 1 and a "Details" textarea with ID 3:
 *   $wpforms_map = array( 'title' => '1', 'description' => '3' );
 */

/* ---------- WPForms integration configured for your site ---------- */
$wpforms_enabled = true;
$wpforms_id      = 27;         // Your WPForms form ID (you provided: [wpforms id="27"])

// Map field IDs/keys from WPForms to project fields. Adjust as needed.
$wpforms_map     = array(
	'title'       => '1',   // <-- REPLACE with the field ID/key used for the project title
	'description' => '2',   // <-- REPLACE with the field ID/key used for the project description
);

if ( $wpforms_enabled ) {
	add_action( 'wpforms_process_complete', function( $fields, $entry, $form_data, $entry_id ) use ( $wpforms_id, $wpforms_map ) {
		// $form_data may be at index 0 if hook signature varies — normalize:
		$form_id = 0;
		if ( is_array( $form_data ) && isset( $form_data['id'] ) ) {
			$form_id = intval( $form_data['id'] );
		} elseif ( is_numeric( $form_data ) ) {
			$form_id = intval( $form_data );
		}

		if ( intval( $form_id ) !== intval( $wpforms_id ) ) {
			return;
		}

		// $fields is an array keyed by field ID; it may contain arrays with 'id' and 'value'
		$title = '';
		$desc  = '';

		// Try to extract using mapped keys
		foreach ( $fields as $field ) {
			$field_id = isset( $field['id'] ) ? (string) $field['id'] : '';
			$value    = isset( $field['value'] ) ? $field['value'] : '';

			if ( $field_id === (string) $wpforms_map['title'] ) {
				$title = sanitize_text_field( $value );
			}
			if ( $field_id === (string) $wpforms_map['description'] ) {
				$desc = wp_kses_post( $value );
			}
		}

		// As a fallback, if title empty try common fields (name/email)
		if ( empty( $title ) ) {
			// look for a single-line text in first field
			reset( $fields );
			$first = current( $fields );
			if ( isset( $first['value'] ) ) {
				$title = sanitize_text_field( $first['value'] );
			}
		}

		if ( empty( $title ) ) {
			$title = sprintf( 'Project from form %d - %s', intval( $form_id ), date_i18n( 'Y-m-d H:i:s' ) );
		}

		$post_data = array(
			'post_type'    => 'rccc_project',
			'post_title'   => $title,
			'post_content' => $desc,
			'post_status'  => 'publish',
			'post_author'  => is_user_logged_in() ? get_current_user_id() : 0,
		);

		$post_id = wp_insert_post( $post_data );

		if ( $post_id && ! is_wp_error( $post_id ) ) {
			add_post_meta( $post_id, '_rccc_form_type', 'wpforms' );
			add_post_meta( $post_id, '_rccc_form_entry_id', intval( $entry_id ) );
		}
	}, 10, 4 );
}