<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue prefill JS only on Get Matched page (or WPForms preview) and only if name/email query params exist.
 * Prefill only name (ID 1) and email (ID 2) to avoid interfering with matching logic.
 */

add_action( 'wp', function() {
	if ( is_admin() ) return;

	// Only load on Get Matched or form preview
	if ( ! is_page( 'get-matched' ) && ! ( isset( $_GET['wpforms_form_preview'] ) && intval( $_GET['wpforms_form_preview'] ) === 27 ) ) {
		return;
	}

	// Only enqueue if name or email present in query
	if ( empty( $_GET['name'] ) && empty( $_GET['email'] ) ) {
		return;
	}

	add_action( 'wp_enqueue_scripts', function() {
		$plugin_root_url = plugin_dir_url( dirname( __FILE__ ) );
		$js_url = $plugin_root_url . 'assets/js/wpforms-prefill.js';

		wp_enqueue_script( 'rccc-wpforms-prefill', $js_url, array(), '1.0', true );

		$config = array(
			'formId' => 27,
			'mapping' => array(
				'name'  => '1',
				'email' => '2',
			),
		);
		wp_localize_script( 'rccc-wpforms-prefill', 'rcccPrefillConfig', $config );
	} );
} );