<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Enqueue a tiny prefill script only on the Get Matched page and only when name/email query params exist.
 * This file pre-fills only Name and Email to avoid any interference with Project Type or ZIP and your matching/emails.
 */

add_action( 'wp', function() {
    if ( is_admin() ) {
        return;
    }

    // Only run when viewing the Get Matched page
    if ( ! is_page( 'get-matched' ) ) {
        // Also allow WPForms preview in case you test with ?wpforms_form_preview=27
        if ( ! ( isset( $_GET['wpforms_form_preview'] ) && intval( $_GET['wpforms_form_preview'] ) === 27 ) ) {
            return;
        }
    }

    // Only enqueue if at least one relevant query param exists
    if ( empty( $_GET['name'] ) && empty( $_GET['email'] ) ) {
        return;
    }

    add_action( 'wp_enqueue_scripts', function() {
        $plugin_root_url = plugin_dir_url( dirname( __FILE__ ) ); // points to plugin root
        $js_url = $plugin_root_url . 'assets/js/wpforms-prefill.js';

        wp_enqueue_script(
            'rccc-wpforms-prefill',
            $js_url,
            array(),
            '1.0',
            true
        );

        // Map only name/email to your WPForms field IDs (you provided these earlier)
        $config = array(
            'formId' => 27,
            'mapping' => array(
                'name'  => '1', // Name field ID
                'email' => '2', // Email field ID
            ),
        );

        wp_localize_script( 'rccc-wpforms-prefill', 'rcccPrefillConfig', $config );
    } );
} );