<?php
/**
 * Plugin Name: RCCC Homeowner Portal
 * Description: Simple homeowner accounts, login/logout and dashboard for Projects/Estimates/Invoices/Complaints/Consultations.
 * Version: 1.1
 * Author: Your Name
 * Text Domain: rccc-homeowner
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'RCCC_HOME_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'RCCC_HOME_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/* Includes */
require_once RCCC_HOME_PLUGIN_DIR . 'includes/cpts.php';
require_once RCCC_HOME_PLUGIN_DIR . 'includes/shortcodes.php';
require_once RCCC_HOME_PLUGIN_DIR . 'includes/integrations.php';

// Optional feature includes (load only if the files exist to avoid fatal errors)
$__rccc_includes_dir = RCCC_HOME_PLUGIN_DIR . 'includes/';
if ( file_exists( $__rccc_includes_dir . 'wpforms-integration.php' ) ) {
	require_once $__rccc_includes_dir . 'wpforms-integration.php';
}
if ( file_exists( $__rccc_includes_dir . 'wpforms-prefill-enqueue.php' ) ) {
	require_once $__rccc_includes_dir . 'wpforms-prefill-enqueue.php';
}

/* Activation / Deactivation */
register_activation_hook( __FILE__, 'rccc_home_activate' );
register_deactivation_hook( __FILE__, 'rccc_home_deactivate' );

function rccc_home_activate() {
	// create homeowner role with minimal capabilities if it doesn't exist
	if ( ! get_role( 'homeowner' ) ) {
		add_role(
			'homeowner',
			__( 'Homeowner', 'rccc-homeowner' ),
			array(
				'read' => true,
			)
		);
	}

	// register CPTs then flush rules
	if ( function_exists( 'rccc_home_register_cpts' ) ) {
		rccc_home_register_cpts();
	}
	flush_rewrite_rules();
}

function rccc_home_deactivate() {
	// flush rewrite rules
	flush_rewrite_rules();
	// Note: we intentionally do not remove the role or any data on deactivation.
}

/**
 * Conditional enqueue: only load CSS when shortcodes are present or on known pages.
 */
add_action( 'wp', 'rccc_home_maybe_enqueue_assets' );
function rccc_home_maybe_enqueue_assets() {
	if ( is_admin() ) {
		return;
	}

	global $post;
	if ( empty( $post ) ) {
		return;
	}

	$shortcodes = array( 'homeowner_register', 'homeowner_login', 'homeowner_account', 'homeowner_logout' );

	foreach ( $shortcodes as $sc ) {
		if ( has_shortcode( $post->post_content, $sc ) ) {
			wp_enqueue_style( 'rccc-home-css', RCCC_HOME_PLUGIN_URL . 'assets/css/homeowner.css', array(), '1.1' );
			return;
		}
	}

	// Also enqueue on specific known slugs (adjust if you used different slugs)
	$slugs_to_check = array( 'create-account', 'create-and-account', 'login', 'homeowner-account' );
	if ( is_page( $slugs_to_check ) ) {
		wp_enqueue_style( 'rccc-home-css', RCCC_HOME_PLUGIN_URL . 'assets/css/homeowner.css', array(), '1.1' );
	}
}