<?php
/**
 * Title: Homepage #1
 * Slug: bluehost-blueprint/homepage-1
 * Categories: bluehost-blueprint
 * Block Types: core/post-content
 *
 * @package Bluehost\Blueprint
 * @since 1.0.0
 */

?>

<!-- wp:group {"metadata":{"name":"Hero"},"align":"full","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"backgroundColor":"accent-4","textColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-color has-accent-4-background-color has-text-color has-background has-link-color"><!-- wp:columns {"verticalAlignment":"center","className":""} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} -->
<div class="wp-block-column is-vertically-aligned-center" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)"><!-- wp:group {"className":"","layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"left","level":1,"className":"is-style-text-wrap-balance","style":{"layout":{"selfStretch":"fit","flexSize":null},"typography":{"fontSize":"3.4em"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base"} -->
<h1 class="wp-block-heading has-text-align-left is-style-text-wrap-balance has-base-color has-text-color has-link-color" style="font-size:3.4em"><?php esc_html_e( 'Actors, Cameras and Achievements', 'bluehost-blueprint' ); ?></h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","className":""} -->
<p class="has-text-align-left"><?php esc_html_e( 'Let\'s make your next award ceremony magnificent', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"width":"","style":{"spacing":{"blockGap":"var:preset|spacing|10"}}} -->
<div class="wp-block-column"><!-- wp:paragraph {"className":""} -->
<p>
<strong><?php esc_html_e( 'Detailed Arrangement', 'bluehost-blueprint' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":""} -->
<p><?php esc_html_e( 'We meticulously organize every aspect for stellar occasions', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"","style":{"spacing":{"blockGap":"var:preset|spacing|10"}}} -->
<div class="wp-block-column"><!-- wp:paragraph {"className":""} -->
<p>
<strong><?php esc_html_e( 'Flawless Performance', 'bluehost-blueprint' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":""} -->
<p><?php esc_html_e( 'All your participants will believe you are a consummate professional.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:buttons {"className":"","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"spacing":{"blockGap":"16px"}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="font-style:normal;font-weight:600"><!-- wp:button {"className":"is-style-fill","fontSize":"medium"} -->
<div class="wp-block-button has-custom-font-size is-style-fill has-medium-font-size"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Prepare Now', 'bluehost-blueprint' ); ?></a></div>
<!-- /wp:button -->

<!-- wp:button {"className":"is-style-outline","style":{"border":{"width":"0px","style":"none"}}} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" style="border-style:none;border-width:0px"><?php esc_html_e( 'Previous Participants', 'bluehost-blueprint' ); ?><span style="margin-left: 8px;">→</span></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"aspectRatio":"1","scale":"cover","sizeSlug":"large","style":{"border":{"radius":{"topLeft":"400px","topRight":"400px","bottomLeft":"400px","bottomRight":"8px"}},"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} -->
<figure class="wp-block-image size-large has-custom-border" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/IRJKLKBWQD.webp' ); ?>" alt="" style="border-top-left-radius:400px;border-top-right-radius:400px;border-bottom-left-radius:400px;border-bottom-right-radius:8px;aspect-ratio:1;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:group {"className":"is-style-block-overlap","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-block-overlap"><!-- wp:columns {"className":"","style":{"border":{"radius":"10px"},"shadow":"var:preset|shadow|natural","color":{"background":"#ffffff"}}} -->
<div class="wp-block-columns has-background" style="border-radius:10px;background-color:#ffffff;box-shadow:var(--wp--preset--shadow--natural)"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:image {"sizeSlug":"large","align":"center"} -->
<figure class="wp-block-image aligncenter size-large"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/218.svg' ); ?>" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:image {"sizeSlug":"large","align":"center"} -->
<figure class="wp-block-image aligncenter size-large"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/216.svg' ); ?>" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:image {"sizeSlug":"large","align":"center"} -->
<figure class="wp-block-image aligncenter size-large"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/211.svg' ); ?>" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:image {"sizeSlug":"large","align":"center"} -->
<figure class="wp-block-image aligncenter size-large"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/217.svg' ); ?>" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-dots","style":{"spacing":{"margin":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|70"}}}} -->
<hr class="wp-block-separator has-alpha-channel-opacity is-style-dots" style="margin-top:var(--wp--preset--spacing--80);margin-bottom:var(--wp--preset--spacing--70)"/>
<!-- /wp:separator -->

<!-- wp:group {"layout":{"type":"constrained","contentSize":"700px"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:heading {"className":"is-style-text-wrap-balance","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"x-large"} -->
<h2 class="wp-block-heading is-style-text-wrap-balance has-x-large-font-size" style="font-style:normal;font-weight:600"><?php esc_html_e( 'Introducing Block Patterns', 'bluehost-blueprint' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"dropCap":true,"className":"is-style-text-wrap-balance"} -->
<p class="has-drop-cap is-style-text-wrap-balance"><?php esc_html_e( 'WordPress block patterns offer a powerful way to create predefined block layouts, enabling users to quickly design pages and posts with a consistent look and feel. These patterns are essentially collections of blocks that are pre-arranged and configured, which you can insert into your posts and pages.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"is-style-default"} -->
<p class="is-style-default"><?php esc_html_e( 'Moreover, the WordPress community and theme developers are actively contributing to a growing library of block patterns, making it easier for users to find a pattern that suits their needs. Whether you\'re building a landing page, a photo gallery, or a complex layout, there\'s likely a block pattern ready to use. This democratizes design for non-technical users while offering developers a way to extend WordPress functionality and provide more options to their clients.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-dots","style":{"spacing":{"margin":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}}} -->
<hr class="wp-block-separator has-alpha-channel-opacity is-style-dots" style="margin-top:var(--wp--preset--spacing--70);margin-bottom:var(--wp--preset--spacing--70)"/>
<!-- /wp:separator -->

<!-- wp:group {"metadata":{"name":"Image + Text Content"},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|70","left":"var:preset|spacing|70"}}}} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/StockSnap_EXZZBXPUS6.webp' ); ?>" alt="" style="border-radius:8px;aspect-ratio:3/4;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:group {"metadata":{"name":"Text Content"},"style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:group {"metadata":{"name":"Top"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"x-large"} -->
<h2 class="wp-block-heading has-x-large-font-size" style="font-style:normal;font-weight:600"><?php esc_html_e( 'About WordPress', 'bluehost-blueprint' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"className":"is-style-text-wrap-balance","fontSize":"medium"} -->
<p class="is-style-text-wrap-balance has-medium-font-size"><?php esc_html_e( 'WordPress is a versatile content management system that powers millions of websites worldwide.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"}}} -->
<p style="font-style:normal;font-weight:700"><a href="#"><?php esc_html_e( 'Learn more →', 'bluehost-blueprint' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Highlights"},"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":"var:preset|spacing|30","padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}}},"backgroundColor":"base-midtone","layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group has-base-midtone-background-color has-background" style="padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--50)"><!-- wp:paragraph -->
<p><strong><?php esc_html_e( 'Key Highlights', 'bluehost-blueprint' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:list {"className":"is-style-text-wrap-balance","style":{"spacing":{"padding":{"right":"1em","left":"1em"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast-midtone"}}}},"textColor":"contrast-midtone"} -->
<ul style="padding-right:1em;padding-left:1em" class="wp-block-list is-style-text-wrap-balance has-contrast-midtone-color has-text-color has-link-color"><!-- wp:list-item -->
<li><?php esc_html_e( 'Open-source software, meaning its source code is freely available for anyone to modify and distribute.', 'bluehost-blueprint' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e( 'Supports multilingual websites, allowing you to create content in multiple languages.', 'bluehost-blueprint' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-dots","style":{"spacing":{"margin":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|70"}}}} -->
<hr class="wp-block-separator has-alpha-channel-opacity is-style-dots" style="margin-top:var(--wp--preset--spacing--80);margin-bottom:var(--wp--preset--spacing--70)"/>
<!-- /wp:separator -->

<!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e( 'Latest from the blog', 'bluehost-blueprint' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:query {"queryId":0,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false,"taxQuery":null,"parents":[]},"layout":{"contentSize":null,"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-query"><!-- wp:post-template {"layout":{"type":"grid","columnCount":null,"minimumColumnWidth":"18rem"}} -->
<!-- wp:group {"className":"is-style-default","style":{"spacing":{"blockGap":"var:preset|spacing|20","margin":{"bottom":"var:preset|spacing|40"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group is-style-default" style="margin-bottom:var(--wp--preset--spacing--40)"><!-- wp:group {"style":{"border":{"radius":"5px"}},"backgroundColor":"base-midtone","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-base-midtone-background-color has-background" style="border-radius:5px"><!-- wp:cover {"useFeaturedImage":true,"dimRatio":0,"customOverlayColor":"#424e71","isUserOverlayColor":false,"minHeight":220,"style":{"border":{"radius":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-radius:5px;min-height:220px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#424e71"></span><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:post-terms {"term":"category","style":{"spacing":{"padding":{"top":"0.3em","bottom":"0.3em","left":"0.5em","right":"0.5em"}},"border":{"radius":"5px"},"typography":{"textTransform":"uppercase"}},"backgroundColor":"base-midtone","fontSize":"small"} /--></div>
<!-- /wp:group -->

<!-- wp:post-title {"isLink":true,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} /-->

<!-- wp:post-date {"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-midtone"}}}},"textColor":"contrast-midtone","fontSize":"small"} /--></div>
<!-- /wp:group -->
<!-- /wp:post-template --></div>
<!-- /wp:query -->