<?php
/** Single template for Contractors */
get_header();
the_post();
$id = get_the_ID();

$logo_id   = get_field('rccc_logo', $id);
$license   = get_field('rccc_license_no', $id);
$bond      = get_field('rccc_bond', $id);
$insurance = get_field('rccc_insurance', $id);
$rating    = get_post_meta($id, 'rccc_rating', true);
$reviews   = (int) get_post_meta($id, 'rccc_reviews', true);
$portfolio = get_field('rccc_portfolio', $id); // repeater
$terms     = get_the_terms($id, 'service_category');

?>
<style>
.rccc-wrap{max-width:1100px;margin:40px auto;padding:0 20px}
.rccc-header{display:flex;gap:20px;align-items:center;margin-bottom:20px}
.rccc-logo img{max-width:120px;border-radius:12px}
.rccc-meta{display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:10px;margin:16px 0}
.rccc-chip{background:#eef3f6;border-radius:10px;padding:8px 12px;font-size:14px}
.rccc-stars{color:#f6b400;font-size:18px}
.rccc-section{margin:32px 0}
.rccc-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(260px,1fr));gap:16px}
.rccc-thumb{border-radius:12px;overflow:hidden;border:1px solid #e6edf2}
.rccc-thumb img{display:block;width:100%;height:auto}
.rccc-reviews .comment{border-bottom:1px solid #eaeef2;padding:12px 0}
.rccc-reviews .review-stars{color:#f6b400}
</style>

<div class="rccc-wrap">
  <div class="rccc-header">
    <div class="rccc-logo">
      <?php if ($logo_id) echo wp_get_attachment_image($logo_id, 'medium'); ?>
    </div>
    <div>
      <h1><?php the_title(); ?></h1>
      <div class="rccc-stars">
        <?php
          $avg = floatval($rating);
          $full = floor($avg);
          $half = ($avg - $full) >= 0.5 ? 1 : 0;
          echo str_repeat('★',$full) . ($half ? '½' : '') . str_repeat('☆', 5 - $full - $half);
          echo $avg ? " ({$avg} / 5, {$reviews} reviews)" : " (No reviews yet)";
        ?>
      </div>
      <?php if ($terms && !is_wp_error($terms)): ?>
        <div class="rccc-meta">
          <div class="rccc-chip"><strong>Services:</strong>
            <?php echo esc_html(implode(', ', wp_list_pluck($terms, 'name'))); ?>
          </div>
          <?php if ($license): ?><div class="rccc-chip"><strong>License:</strong> <?php echo esc_html($license); ?></div><?php endif; ?>
          <?php if ($bond): ?><div class="rccc-chip"><strong>Bond:</strong> <?php echo esc_html($bond); ?></div><?php endif; ?>
          <?php if ($insurance): ?><div class="rccc-chip"><strong>Insurance:</strong> <?php echo esc_html($insurance); ?></div><?php endif; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="rccc-section">
    <?php the_content(); ?>
  </div>

  <?php if ($portfolio): ?>
    <div class="rccc-section">
      <h2>Recent Projects (Before &amp; After)</h2>
      <?php foreach ($portfolio as $proj): ?>
        <h3><?php echo esc_html($proj['project_title'] ?: 'Project'); ?></h3>
        <div class="rccc-grid">
          <?php
            $before = (array) ($proj['before_gallery'] ?: []);
            $after  = (array) ($proj['after_gallery']  ?: []);
            foreach ($before as $img_id) {
              echo '<figure class="rccc-thumb"><figcaption style="padding:8px">Before</figcaption>'.
                   wp_get_attachment_image($img_id, 'large') . '</figure>';
            }
            foreach ($after as $img_id) {
              echo '<figure class="rccc-thumb"><figcaption style="padding:8px">After</figcaption>'.
                   wp_get_attachment_image($img_id, 'large') . '</figure>';
            }
          ?>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <div class="rccc-section rccc-reviews">
    <h2>Homeowner Reviews</h2>
    <?php
      $comments = get_comments(['post_id' => $id, 'status' => 'approve']);
      if ($comments) {
        foreach ($comments as $c) {
          $r = (int) get_comment_meta($c->comment_ID, 'rating', true);
          echo '<div class="comment">';
          echo '<div class="review-stars">'. str_repeat('★',$r) . str_repeat('☆', 5-$r) . '</div>';
          echo '<p><strong>'. esc_html($c->comment_author) .'</strong> – '. esc_html(get_comment_date('', $c)) .'</p>';
          echo wpautop(esc_html($c->comment_content));
          echo '</div>';
        }
      } else {
        echo '<p>No reviews yet. Be the first to write one.</p>';
      }
      comment_form([
        'title_reply'  => 'Leave a review',
        'label_submit' => 'Submit Review',
        'comment_notes_before' => '<p>Your email will not be published.</p>',
        'comment_field' => '<p class="comment-form-comment"><label for="comment">Comments</label><textarea id="comment" name="comment" required></textarea></p>',
      ]);
    ?>
  </div>
</div>

<?php get_footer(); ?>
