<?php
/**
 * Title: Homepage #2
 * Slug: bluehost-blueprint/homepage-2
 * Categories: bluehost-blueprint
 * Block Types: core/post-content
 *
 * @package Bluehost\Blueprint
 * @since 1.0.0
 */

?>

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center","justifyContent":"center"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"padding":{"right":"16px","left":"16px","top":"6px","bottom":"6px"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"25px"}},"backgroundColor":"accent-1","textColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-base-color has-accent-1-background-color has-text-color has-background has-link-color" style="border-radius:25px;padding-top:6px;padding-right:16px;padding-bottom:6px;padding-left:16px"><!-- wp:paragraph {"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} -->
<p class="has-small-font-size" style="font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e( 'Our Purpose', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"xx-large"} -->
<h2 class="wp-block-heading has-text-align-center has-xx-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Guiding Beliefs', 'bluehost-blueprint' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-midtone"}}}},"textColor":"contrast-midtone","fontSize":"large"} -->
<p class="has-text-align-center has-contrast-midtone-color has-text-color has-link-color has-large-font-size"><?php esc_html_e( 'Empower your future with exciting challenges and a supportive environment. Join us!', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:gallery {"linkTo":"none","sizeSlug":"full"} -->
<figure class="wp-block-gallery has-nested-images columns-default is-cropped"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/17877804936_810a01baed_k_1.webp' ); ?>" alt="" class=""/></figure>
<!-- /wp:image -->

<!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/14238079282_271759b798_k_1.webp' ); ?>" alt="" class=""/></figure>
<!-- /wp:image -->

<!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/3296444307_ccc20be908_k_1.webp' ); ?>" alt="" class=""/></figure>
<!-- /wp:image --></figure>
<!-- /wp:gallery -->

<!-- wp:social-links {"iconColor":"base","iconColorValue":"#ffffff","iconBackgroundColor":"accent-2","iconBackgroundColorValue":"#606C38","layout":{"type":"flex","justifyContent":"center"}} -->
<ul class="wp-block-social-links has-icon-color has-icon-background-color"><!-- wp:social-link {"url":"#","service":"youtube"} /-->

<!-- wp:social-link {"url":"#","service":"instagram"} /-->

<!-- wp:social-link {"url":"#","service":"mail"} /--></ul>
<!-- /wp:social-links -->

<!-- wp:spacer {"height":"50px"} -->
<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"metadata":{"name":"Two columns text"},"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained","contentSize":"740px","wideSize":"800px"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"className":"is-style-text-wrap-balance","style":{"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"2em"}}} -->
<h2 class="wp-block-heading is-style-text-wrap-balance" style="font-size:2em;font-style:normal;font-weight:600"><?php esc_html_e( 'A journey commenced, starting cheerfully under a clear sky, and a tranquil sea.', 'bluehost-blueprint' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"className":"is-style-text-wrap-balance"} -->
<p class="is-style-text-wrap-balance"><?php esc_html_e( 'They walked out onto the deck. All the buildings and smoke had vanished, and the ship was in a vast expanse of sea, fresh and clear yet faint in the morning light.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"is-style-text-wrap-balance"} -->
<p class="is-style-text-wrap-balance"><?php esc_html_e( 'They had departed from the city lying in the mud. A very thin silhouette stretched on the horizon, barely strong enough to support the weight of a distant city, which still lay upon it. They were free from paths, free from people, and a shared sense of liberation filled them all.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"className":"is-style-text-wrap-balance"} -->
<p class="is-style-text-wrap-balance"><?php esc_html_e( 'The ship moved steadily through small waves that splashed her and then fizzled like sparkling water, leaving a little trail of bubbles and foam on each side. The dull October sky above was lightly veiled as if by smoke from a fire, and the air was refreshingly salty and brisk. Indeed, it was too chilly to stay still.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"is-style-text-wrap-balance"} -->
<p class="is-style-text-wrap-balance"><?php esc_html_e( 'Mrs. Brown took her husband`s arm, and as they walked away, it was clear from the way her tilted cheek turned up to his that she had something private to share.', 'bluehost-blueprint' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"50px"} -->
<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"metadata":{"name":"Heading + Media"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-midtone","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-midtone-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:group {"metadata":{"name":"Heading"},"layout":{"type":"constrained","contentSize":"740px"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"center","level":1,"className":"is-style-text-wrap-balance","style":{"typography":{"fontSize":"3em","fontStyle":"normal","fontWeight":"500"}}} -->
<h1 class="wp-block-heading has-text-align-center is-style-text-wrap-balance" style="font-size:3em;font-style:normal;font-weight:500"><?php esc_html_e( 'Our vision for building the web a better place, one site at a time', 'bluehost-blueprint' ); ?></h1>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Media"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|70"}}},"layout":{"type":"constrained","contentSize":"940px"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--70)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/assets/images/8447530115_42bdfd9db6_k.webp' ); ?>","dimRatio":30,"overlayColor":"header-foreground","isUserOverlayColor":true,"minHeight":40,"minHeightUnit":"vh","contentPosition":"center center","style":{"dimensions":{"aspectRatio":"16/9"},"border":{"radius":"10px"}},"layout":{"type":"constrained","contentSize":""}} -->
<div class="wp-block-cover" style="border-radius:10px;min-height:40vh"><span aria-hidden="true" class="wp-block-cover__background has-header-foreground-background-color has-background-dim-30 has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/8447530115_42bdfd9db6_k.webp' ); ?>" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:social-links {"iconColor":"base","iconColorValue":"#ffffff","iconBackgroundColor":"contrast-midtone","iconBackgroundColorValue":"#3d3d3d","size":"has-large-icon-size","className":"is-style-default","layout":{"type":"flex","justifyContent":"center"}} -->
<ul class="wp-block-social-links has-large-icon-size has-icon-color has-icon-background-color is-style-default"><!-- wp:social-link {"url":"#","service":"youtube"} /--></ul>
<!-- /wp:social-links --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->