<?php
/**
 * Plugin Name: RCCC – Contractor Single: 2-Column Layout + Cleanup (Late Wrapper)
 * Description: Server-side two-column layout for single contractor pages with right-rail sidebar. Hides gray meta strip and bottom spacer bar. No JS required.
 * Version: 1.1.0
 * Author: RCCC
 */

if (!defined('ABSPATH')) exit;

/* 1) Sidebar for right rail */
add_action('widgets_init', function () {
    register_sidebar([
        'name'          => 'RCCC Contractor Sidebar',
        'id'            => 'rccc_contractor_sidebar',
        'description'   => 'Right side of single contractor pages. Add Image, Custom HTML, Shortcode, etc.',
        'before_widget' => '<div class="rccc-ad">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="rccc-ad-title">',
        'after_title'   => '</h4>',
    ]);
});

/* 2) Wrap FINAL content (very late) so we don't fight other filters */
add_filter('the_content', function ($content) {
    if ( !is_singular('contractor') || !in_the_loop() || !is_main_query() ) return $content;

    // Don't double wrap
    if (strpos($content, 'class="rccc-layout"') !== false) return $content;

    // Build right rail
    ob_start();
    if ( is_active_sidebar('rccc_contractor_sidebar') ) {
        dynamic_sidebar('rccc_contractor_sidebar');
    } else {
        echo '<div class="rccc-ad rccc-ad--ph">Publicity 300×250</div>';
        echo '<div class="rccc-ad rccc-ad--ph rccc-ad--tall">Publicity 300×600</div>';
    }
    $aside = ob_get_clean();

    $html  = '<!-- RCCC two-col wrapper start -->';
    $html .= '<div class="rccc-layout">';
    $html .=   '<div class="rccc-main">'.$content.'</div>';
    $html .=   '<aside class="rccc-aside">'.$aside.'</aside>';
    $html .= '</div>';
    $html .= '<!-- RCCC two-col wrapper end -->';

    return $html;
}, 9999);

/* 3) CSS: grid + cleanup */
add_action('wp_enqueue_scripts', function () {
    if ( !is_singular('contractor') ) return;

    // Register a tiny handle to attach inline styles reliably
    wp_register_style('rccc-two-col-base', false, [], null);
    wp_enqueue_style('rccc-two-col-base');

    $css = <<<CSS
/* --- Layout container --- */
body.single-contractor .wp-block-post-content,
body.single-contractor .entry-content { max-width: none !important; }

body.single-contractor .rccc-layout{
  display:grid; grid-template-columns:minmax(0,1fr) 320px; gap:24px;
  align-items:start; max-width:1200px; margin:0 auto; padding:0 16px;
}

@media (max-width:1024px){
  body.single-contractor .rccc-layout{ grid-template-columns:1fr; }
  body.single-contractor .rccc-aside{ position:static; order:2; }
}

/* Stretch children in main */
body.single-contractor .rccc-main > *{ width:100%; }

/* Right rail cards / placeholders */
body.single-contractor .rccc-aside{ position:sticky; top:96px; }
body.single-contractor .rccc-aside .rccc-ad{
  background:#fff; border:1px solid #e5e7eb; border-radius:12px;
  padding:12px; margin-bottom:12px; color:#64748b;
}
body.single-contractor .rccc-aside .rccc-ad--ph{ background:#f8fafc; }
body.single-contractor .rccc-aside .rccc-ad--tall{ min-height:600px; }

/* Card & reviews (safety if theme stripped your plugin styles) */
body.single-contractor .rccc-single-card{
  background:#fff; border:1px solid #e5e7eb; border-radius:16px;
  padding:20px; box-shadow:0 4px 14px rgba(0,0,0,.06);
}
body.single-contractor .rccc-reviews{
  margin-top:24px; padding:16px; border:1px solid #e5e7eb; border-radius:12px; background:#fff;
}

/* --- Hide the theme's gray meta/excerpt strip near the top --- */
body.single-contractor .entry-header .entry-meta,
body.single-contractor .entry-header .posted-on,
body.single-contractor .entry-header .byline,
body.single-contractor .wp-block-post-excerpt,
body.single-contractor .wp-block-post-date,
body.single-contractor .wp-block-post-author,
body.single-contractor .wp-block-post-terms,
body.single-contractor .single-post-meta,
body.single-contractor .post-meta,
body.single-contractor .meta, 
body.single-contractor .entry-summary { display:none !important; }

/* --- Kill bottom white bar / fluff around content --- */
body.single-contractor .wp-block-separator,
body.single-contractor .wp-block-spacer,
body.single-contractor .entry-content > hr,
body.single-contractor .nav-links,
body.single-contractor .post-navigation,
body.single-contractor .entry-footer { display:none !important; }

body.single-contractor .rccc-layout{ margin-bottom: 0; }
body.single-contractor .site-main, 
body.single-contractor .content-area, 
body.single-contractor .wp-block-post-content, 
body.single-contractor .entry-content { margin-bottom: 0 !important; padding-bottom: 0 !important; }
CSS;

    wp_add_inline_style('rccc-two-col-base', $css);
}, 99);
